package gov.va.med.mhv.admin.service.calendar;

import java.util.List;

import javax.ws.rs.core.Response;

import gov.va.med.mhv.admin.dto.CalendarCategoryDTO;
import gov.va.med.mhv.admin.dto.CalendarEventDTO;
import gov.va.med.mhv.admin.dto.CalendarSearchCriteriaDTO;
import gov.va.med.mhv.admin.dto.CategoryDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.admin.dto.MHVEventModel;
import gov.va.med.mhv.admin.dto.VisnDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

public interface CalendarService {

	public ResponseUtil<List<MHVEventModel>> findEventsForUser(CalendarSearchCriteriaDTO searchCriteria) throws MHVException;

	public List<MHVEventModel> searchEventsForUser(CalendarSearchCriteriaDTO searchCriteria) throws MHVException;

	public List<CategoryDTO> getAllCategories() throws MHVException;

	public List<CalendarCategoryDTO> getAllActiveCategories(Long userProfileId) throws MHVException;

	public List<CategoryDTO> getCheckedCategories(Long userProfileId) throws MHVException;

	public void saveCalendarEvent(CalendarEventDTO calendarEventDto) throws MHVException;

	public void deleteCalendarEvent(Long calendarEventId) throws MHVException;

	public void saveUserCalCatList(List<CategoryDTO> userCalCatList, Long userProfileId) throws MHVException;

	public Response generateReport(String rangeStart, String rangeEnd, String eventTypes);

	public MHVEventModel getPersonalEventById(Long eventId) throws MHVException;
	
	public List<VisnDTO> getAllVisns() throws MHVException;
	
	public void  saveCalendarCategory(CalendarCategoryDTO categoryDTO) throws MHVException;
	
	public void  deleteCalendarCategory(Long categoryId) throws MHVException;

}
